function fout = encode(fin,Fs,Fc)
%% Design the Hilber transformer
% Note:  firpm() seems to need the band edges to be symmetric about 0.5
h1=firpm(150,[300*2/Fs 1-300*2/Fs],[1 1 ],'Hilbert');
y1=fftfilt(h1,fin);
%% Delay: Approach 1
N=length(h1); %N is odd
y2=zeros(size(fin));y2((N-1)/2+1:end)=fin(1:end-(N-1)/2);
%% Delay: Design the delay filter, Approach 2
% h2 = zeros(1,length(h1));
% h2((N-1)/2+1) = 1;
% Filter the data
% y2=fftfilt(h2,fin);
%% Filter Output
t=(0:length(fin)-1)*(1/Fs);
y3=-y1.*sin(2*pi*Fc*t');
y4=-y2.*cos(2*pi*Fc*t');
fout= y3+y4;
%% Plots:
figure
freqz(h1,1)
title('Hilbert Filter for Encoder')

mag_plot(fin ,Fs,'(2): Magnitude Spectrum of Encoder Input (After Audio Filter)')
mag_plot(fout,Fs,'(3): Magnitude Spectrum of Encoder Output')
